<#ibiztemplate>
TARGET=PSDATAENTITY
</#ibiztemplate>
package ${pub.getPKGCodeName()}.core.${item.getPSSystemModule().getCodeName()?lower_case}.filter;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.HashMap;

import lombok.*;
import lombok.extern.slf4j.Slf4j;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.alibaba.fastjson.annotation.JSONField;

import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

<#comment>SQL存储-Mybatis</#comment>
<#if de.getStorageMode()==1>

import ${pub.getPKGCodeName()}.util.filter.QueryWrapperContext;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import ${pub.getPKGCodeName()}.core.${item.getPSSystemModule().codeName?lower_case}.domain.${item.getCodeName()};
/**
 * 关系型数据实体[${item.codeName}] 查询条件对象
 */
@Slf4j
@Data
public class ${item.codeName}SearchContext extends QueryWrapperContext<${item.codeName}> {

    <#list item.getPSDEFields() as defield>
        <#if defield.getAllPSDEFSearchModes()??>
            <#list defield.getAllPSDEFSearchModes() as formitem>
                <#if formitem.getPSDEField()??>
                    <#assign defDataType=formitem.getPSDEField().getDataType()>
                    <#if defDataType == "DATETIME">
    @JsonFormat(pattern="yyyy-MM-dd HH:mm:ss", timezone="GMT+8")
    @JSONField(format="yyyy-MM-dd HH:mm:ss")
                    <#elseif defDataType == "DATE">
    @JsonFormat(pattern="yyyy-MM-dd", timezone="GMT+8")
    @JSONField(format="yyyy-MM-dd")
                    <#elseif defDataType == "TIME">
    @JsonFormat(pattern="HH:mm", timezone="GMT+8")
    @JSONField(format="HH:mm")
                    </#if>
	private ${srfjavatype(formitem.getPSDEField().stdDataType)} ${formitem.getName()?lower_case};//[${defield.getLogicName()}]
	public void set${formitem.getName()?lower_case?cap_first}(${srfjavatype(formitem.getPSDEField().stdDataType)} ${formitem.getName()?lower_case}) {
        this.${formitem.getName()?lower_case} = ${formitem.getName()?lower_case};
        if(!ObjectUtils.isEmpty(this.${formitem.getName()?lower_case})){
                    <#if formitem.getValueOp() == "LIKE">
            this.getSelectCond().like("${formitem.getPSDEField().getName()?lower_case}", ${formitem.getName()?lower_case});
                    <#elseif formitem.getValueOp() == "LEFTLIKE">
            this.getSelectCond().likeRight("${formitem.getPSDEField().getName()?lower_case}", ${formitem.getName()?lower_case});
                    <#elseif formitem.getValueOp() == "RIGHTLIKE">
            this.getSelectCond().likeLeft("${formitem.getPSDEField().getName()?lower_case}", ${formitem.getName()?lower_case});
                    <#elseif formitem.getValueOp() == "EQ">
            this.getSelectCond().eq("${formitem.getPSDEField().getName()?lower_case}", ${formitem.getName()?lower_case});
                    <#elseif formitem.getValueOp() == "NOTEQ">
            this.getSelectCond().ne("${formitem.getPSDEField().getName()?lower_case}", ${formitem.getName()?lower_case});
                    <#elseif formitem.getValueOp() == "GT">
            this.getSelectCond().gt("${formitem.getPSDEField().getName()?lower_case}", ${formitem.getName()?lower_case});
                    <#elseif formitem.getValueOp() == "GTANDEQ">
            this.getSelectCond().ge("${formitem.getPSDEField().getName()?lower_case}", ${formitem.getName()?lower_case});
                    <#elseif formitem.getValueOp() == "LT">
            this.getSelectCond().lt("${formitem.getPSDEField().getName()?lower_case}", ${formitem.getName()?lower_case});
                    <#elseif formitem.getValueOp() == "LTANDEQ">
            this.getSelectCond().le("${formitem.getPSDEField().getName()?lower_case}", ${formitem.getName()?lower_case});
                    <#elseif formitem.getValueOp() == "ISNOTNULL">
			if(this.${formitem.getName()?lower_case}.toString().equals("1")){
				this.getSelectCond().isNotNull("${formitem.getPSDEField().getName()?lower_case}");
			}
                    <#elseif formitem.getValueOp() == "ISNULL">
			if(this.${formitem.getName()?lower_case}.toString().equals("1")){
				this.getSelectCond().isNull("${formitem.getPSDEField().getName()?lower_case}");
			}
                    <#elseif formitem.getValueOp() == "IN">
                        <#if formitem.getPSCodeListId()??>
                            <#assign codeListName=getCodeListName(formitem.getPSCodeListId())>
            String defaultSeparator=(CodeListBase.getCodeList("${codeListName}")==null)?";":CodeListBase.getCodeList("${codeListName}").getCodeList().getValueseparator();
                        <#else >
            String defaultSeparator=";";
                        </#if>
			this.getSelectCond().in("${formitem.getPSDEField().getName()?lower_case}",this.${formitem.getName()?lower_case}.split(defaultSeparator));
                    <#elseif formitem.getValueOp() == "NOTIN">
                        <#if formitem.getPSCodeListId()??>
                            <#assign codeListName=getCodeListName(formitem.getPSCodeListId())>
            String defaultSeparator=(CodeListBase.getCodeList("${codeListName}")==null)?";":CodeListBase.getCodeList("${codeListName}").getCodeList().getValueseparator();
                        <#else >
            String defaultSeparator=";";
                        </#if>
            String defaultSeparator=";";
			this.getSelectCond().notIn("${formitem.getPSDEField().getName()?lower_case}",this.${formitem.getName()?lower_case}.split(defaultSeparator));
                    </#if>
        }
    }
                </#if>
            </#list>
        </#if>
    </#list>

    /**
	 * 启用快速搜索
	 */
	public void setQuery(String query)
	{
		 this.query=query;
		 if(!StringUtils.isEmpty(query)){
	<#assign bFisrtLoop = true >
	<#assign bHasSearch = false >
    <#list item.getPSDEFields() as defield>
        <#if defield.isEnableQuickSearch()==true >
            <#assign bHasSearch = true >
            <#if bFisrtLoop>
            this.getSelectCond().and( wrapper ->
                     wrapper.like("${defield.name?lower_case}", query)   
            <#assign bFisrtLoop = false >         
            <#else>
                        .or().like("${defield.name?lower_case}", query)            
            </#if>
        </#if>
    </#list>
    <#if bHasSearch>
            );
    </#if>
		 }
	}
}

<#comment>NoSQL存储-MongoDB</#comment>
<#elseif de.getStorageMode()==2>

import ${pub.getPKGCodeName()}.util.filter.QueryBuildContext;
import ${pub.getPKGCodeName()}.core.${item.getPSSystemModule().codeName?lower_case}.domain.${item.getCodeName()};
import java.util.regex.Pattern;
import com.mongodb.BasicDBObject;

/**
 * NoSQL数据实体[${item.codeName}] 查询条件对象
 */
@Slf4j
@Data
public class ${item.codeName}SearchContext extends QueryBuildContext {

    <#list item.getPSDEFields() as defield>
        <#if defield.getAllPSDEFSearchModes()??>
            <#list defield.getAllPSDEFSearchModes() as formitem>
                <#if formitem.getPSDEField()??>
                    <#assign defDataType=formitem.getPSDEField().getDataType()>
                    <#if defDataType == "DATETIME">
    @JsonFormat(pattern="yyyy-MM-dd HH:mm:ss", timezone="GMT+8")
    @JSONField(format="yyyy-MM-dd HH:mm:ss")
                    <#elseif defDataType == "DATE">
    @JsonFormat(pattern="yyyy-MM-dd", timezone="GMT+8")
    @JSONField(format="yyyy-MM-dd")
                    <#elseif defDataType == "TIME">
    @JsonFormat(pattern="HH:mm", timezone="GMT+8")
    @JSONField(format="HH:mm")
                    </#if>
	private ${srfjavatype(formitem.getPSDEField().stdDataType)} ${formitem.getName()?lower_case};//[${defield.getLogicName()}]
	public void set${formitem.getName()?lower_case?cap_first}(${srfjavatype(formitem.getPSDEField().stdDataType)} ${formitem.getName()?lower_case}) {
        this.${formitem.getName()?lower_case} = ${formitem.getName()?lower_case};
        if(!ObjectUtils.isEmpty(this.${formitem.getName()?lower_case})){
                    <#if formitem.getValueOp() == "LIKE">
            Pattern pattern = Pattern.compile("^.*" + ${formitem.getName()?lower_case} + ".*$", Pattern.CASE_INSENSITIVE);
            this.getSelectCond().and("${formitem.getPSDEField().getName()?lower_case}").regex(pattern);
                    <#elseif formitem.getValueOp() == "LEFTLIKE">
            Pattern pattern = Pattern.compile( ${formitem.getName()?lower_case} + ".*$", Pattern.CASE_INSENSITIVE);
            this.getSelectCond().and("${formitem.getPSDEField().getName()?lower_case}").regex(pattern);
                    <#elseif formitem.getValueOp() == "RIGHTLIKE">
            Pattern pattern = Pattern.compile("^.*" + ${formitem.getName()?lower_case} + "$", Pattern.CASE_INSENSITIVE);
            this.getSelectCond().and("${formitem.getPSDEField().getName()?lower_case}").regex(pattern);
                    <#elseif formitem.getValueOp() == "EQ">
            this.getSelectCond().and("${formitem.getPSDEField().getName()?lower_case}").is(${formitem.getName()?lower_case});
                    <#elseif formitem.getValueOp() == "NOTEQ">
            this.getSelectCond().and("${formitem.getPSDEField().getName()?lower_case}").notEquals(${formitem.getName()?lower_case});
                    <#elseif formitem.getValueOp() == "GT">
            this.getSelectCond().and("${formitem.getPSDEField().getName()?lower_case}").greaterThan(${formitem.getName()?lower_case});
                    <#elseif formitem.getValueOp() == "GTANDEQ">
            this.getSelectCond().and("${formitem.getPSDEField().getName()?lower_case}").greaterThanEquals(${formitem.getName()?lower_case});
                    <#elseif formitem.getValueOp() == "LT">
            this.getSelectCond().and("${formitem.getPSDEField().getName()?lower_case}").lessThan(${formitem.getName()?lower_case});
                    <#elseif formitem.getValueOp() == "LTANDEQ">
            this.getSelectCond().and("${formitem.getPSDEField().getName()?lower_case}").lessThanEquals(${formitem.getName()?lower_case});
                    <#elseif formitem.getValueOp() == "ISNOTNULL">
			if(this.${formitem.getName()?lower_case}.toString().equals("1")){
				this.getSelectCond().and("${formitem.getPSDEField().getName()?lower_case}").exists(true).and("${formitem.getPSDEField().getName()?lower_case}").notEquals("").and("${formitem.getPSDEField().getName()?lower_case}").notEquals(null);
			}
                    <#elseif formitem.getValueOp() == "ISNULL">
			if(this.${formitem.getName()?lower_case}.toString().equals("1")){
				this.getSelectCond().and("${formitem.getPSDEField().getName()?lower_case}").exists(null);
			}
                    <#elseif formitem.getValueOp() == "IN">
                        <#if formitem.getPSCodeListId()??>
                            <#assign codeListName=getCodeListName(formitem.getPSCodeListId())>
            String defaultSeparator=(CodeListBase.getCodeList("${codeListName}")==null)?";":CodeListBase.getCodeList("${codeListName}").getCodeList().getValueseparator();
                        <#else >
            String defaultSeparator=";";
                        </#if>
			this.getSelectCond().and("${formitem.getPSDEField().getName()?lower_case}").in(this.${formitem.getName()?lower_case}.split(defaultSeparator)));
                    <#elseif formitem.getValueOp() == "NOTIN">
                        <#if formitem.getPSCodeListId()??>
                            <#assign codeListName=getCodeListName(formitem.getPSCodeListId())>
            String defaultSeparator=(CodeListBase.getCodeList("${codeListName}")==null)?";":CodeListBase.getCodeList("${codeListName}").getCodeList().getValueseparator();
                        <#else >
            String defaultSeparator=";";
                        </#if>
            String defaultSeparator=";";
			this.getSelectCond().and("${formitem.getPSDEField().getName()?lower_case}").notIn(this.${formitem.getName()?lower_case}.split(defaultSeparator)));
                    </#if>
        }
    }
                </#if>
            </#list>
        </#if>
    </#list>

    /**
	 * 启用快速搜索
	 */
	public void setQuery(String query)
	{
		 this.query=query;
		 if(!StringUtils.isEmpty(query)){
    <#list item.getPSDEFields() as defield>
        <#if defield.isEnableQuickSearch()==true>
            Pattern pattern = Pattern.compile("^.*" + query + ".*$", Pattern.CASE_INSENSITIVE);
            this.getSelectCond().or(new BasicDBObject("${defield.name?lower_case}",pattern));
        </#if>
    </#list>
		 }
	}
}
<#comment>ServiceApi</#comment>
<#elseif de.getStorageMode()==4>

import ${pub.getPKGCodeName()}.util.filter.SearchContextBase;

/**
 * ServiceApi数据实体[${item.codeName}] 查询条件对象
 */
@Slf4j
@Data
public class ${item.codeName}SearchContext extends SearchContextBase {
    <#list item.getPSDEFields() as defield>
        <#if defield.getAllPSDEFSearchModes()??>
            <#list defield.getAllPSDEFSearchModes() as formitem>
                <#if formitem.getPSDEField()??>
                    <#assign defDataType=formitem.getPSDEField().getDataType()>
                    <#if defDataType == "DATETIME">
    @JsonFormat(pattern="yyyy-MM-dd HH:mm:ss", timezone="GMT+8")
    @JSONField(format="yyyy-MM-dd HH:mm:ss")
                    <#elseif defDataType == "DATE">
    @JsonFormat(pattern="yyyy-MM-dd", timezone="GMT+8")
    @JSONField(format="yyyy-MM-dd")
                    <#elseif defDataType == "TIME">
    @JsonFormat(pattern="HH:mm", timezone="GMT+8")
    @JSONField(format="HH:mm")
                    </#if>
	private ${srfjavatype(formitem.getPSDEField().stdDataType)} ${formitem.getName()?lower_case};//[${defield.getLogicName()}]

                </#if>
            </#list>
        </#if>
    </#list>
}
<#elseif de.getStorageMode()==0>

import ${pub.getPKGCodeName()}.util.filter.SearchContextBase;

/**
 * ServiceApi数据实体[${item.codeName}] 查询条件对象
 */
@Slf4j
@Data
public class ${item.codeName}SearchContext extends SearchContextBase {
    <#list item.getPSDEFields() as defield>
        <#if defield.getAllPSDEFSearchModes()??>
            <#list defield.getAllPSDEFSearchModes() as formitem>
                <#if formitem.getPSDEField()??>
                    <#assign defDataType=formitem.getPSDEField().getDataType()>
                    <#if defDataType == "DATETIME">
    @JsonFormat(pattern="yyyy-MM-dd HH:mm:ss", timezone="GMT+8")
    @JSONField(format="yyyy-MM-dd HH:mm:ss")
                    <#elseif defDataType == "DATE">
    @JsonFormat(pattern="yyyy-MM-dd", timezone="GMT+8")
    @JSONField(format="yyyy-MM-dd")
                    <#elseif defDataType == "TIME">
    @JsonFormat(pattern="HH:mm", timezone="GMT+8")
    @JSONField(format="HH:mm")
                    </#if>
	private ${srfjavatype(formitem.getPSDEField().stdDataType)} ${formitem.getName()?lower_case};//[${defield.getLogicName()}]

                </#if>
            </#list>
        </#if>
    </#list>
}
</#if>



